/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIRangedAttack;
import lotr.common.entity.item.LOTREntityArrowMorgul;
import lotr.common.entity.item.LOTREntityArrowWeak;
import lotr.common.entity.npc.LOTREntityAngmarOrc;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.item.LOTRItemBow;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityAngmarOrcArcher
extends LOTREntityAngmarOrc {
    public LOTREntityAngmarOrcArcher(World world) {
        super(world);
    }

    @Override
    public EntityAIBase createOrcAttackAI() {
        return new LOTREntityAIRangedAttack(this, 1.25, 30, 60, 16.0f);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setRangedWeapon(new ItemStack(LOTRMod.orcBow));
        this.npcItemsInv.setIdleItem(this.npcItemsInv.getRangedWeapon());
        return data;
    }

    @Override
    protected void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.func_70062_b(0, this.npcItemsInv.getIdleItem());
        } else {
            this.func_70062_b(0, this.npcItemsInv.getRangedWeapon());
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        this.dropNPCArrows(i);
    }

    protected float getMorgulArrowChance() {
        return 0.06666667f;
    }

    protected float getWeakArrowChance() {
        return 0.06666667f;
    }

    @Override
    protected void npcArrowAttack(EntityLivingBase target, float f) {
        ItemStack heldItem = this.func_70694_bm();
        float str = 1.3f + this.func_70032_d((Entity)target) / 80.0f;
        float accuracy = (float)this.func_110148_a(npcRangedAccuracy).func_111126_e();
        float poisonChance = this.getMorgulArrowChance();
        float weakArrowChance = this.getWeakArrowChance();
        EntityArrow arrow = this.field_70146_Z.nextFloat() < poisonChance ? new LOTREntityArrowMorgul(this.field_70170_p, (EntityLivingBase)this, target, str, accuracy) : (this.field_70146_Z.nextFloat() < weakArrowChance ? new LOTREntityArrowWeak(this.field_70170_p, (EntityLivingBase)this, target, str, accuracy) : new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, str *= LOTRItemBow.getLaunchSpeedFactor(heldItem), accuracy));
        if (heldItem != null) {
            LOTRItemBow.applyBowModifiers(arrow, heldItem);
        }
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }
}

